//-----------------------------------------------------------------------
// スイッチでカウント
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <RPlib.h>
#include <LedControl.h>
#include <Button.h>

LedControl lc = LedControl(11, 13, 1); //７セグメントLEDを使うときのオマジナイ
Button SW1    = Button(D2, HIGH);      //D2に接続されたスイッチをSW1と命名する(HIGHになったらスイッチオン)

void setup(){
    lc.shutdown(0, false);             //７セグメントLEDをリセット
    lc.setIntensity(0, 4);             //色の濃さ(0-8)
    lc.clearDisplay(0);                //表示クリア
}

int count = 0;

void loop(){
    SW1.listen();
    if(SW1.onPress()){                 //もしスイッチがおされたら
        count++;                       //カウント
    }
    lc.setDec(0, count);               //変数countの内容を表示
    delay(100);
}
