//-----------------------------------------------------------------------
//  7セグメントLEDとカラーセンサーを複合的に使う
//　さらに音を出す
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

#include <ColorSensor.h>
#include <LedControl.h>
#include <Tone.h>
#include <RPlib.h>

LedControl lc = LedControl(11, 13, 1);                //７セグメントLEDを使うときのオマジナイ
Tone tone1;

void setup(){
    tone1.begin(D3);
    lc.shutdown(0, false);                            //７セグメントLEDをリセット
    lc.setIntensity(0, 4);                            //色の濃さ(0-8)
    lc.clearDisplay(0);                               //表示クリア
    ColorSensor.begin(1000, 0);                       // カラーセンサーの積分時間を指定 x1/10[ms]　 値が大きいほどセンサー値の精度が良くなるがそのぶん時間がかかる(6000で600[ms] 最大 6144)
    for(int i = 4; i < 8; i++) ColorSensor.ledOn(i);  //照明用LEDの点灯
}

void loop(){
    if (ColorSensor.colorRead()){                     //カラーセンサーから読み込む
        word clear = ColorSensor.colorClear();

        word red   = ColorSensor.colorRed();          //RGBのRの値
        word green = ColorSensor.colorGreen();        //RGBのGの値
        word blue  = ColorSensor.colorBlue();         //RGBのBの値

        ColorSensor.convertHSV(red, green, blue);
        word h = ColorSensor.convertH();

        tone1.play(h, 10);                            //色相hを周波数で表現
        lc.setDec(0, h);                              //色相hをLEDで表示
        //delay(100);
    }
}
