//-----------------------------------------------------------------------
// スロットマシン１
// 0-9カウンターを回す
// A0でストップをかける
// 音をつける
// 当たりをつける（当たりはスリーセブン）
// 3スロット
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <LedControl.h>
#include <Tone.h>                                                              //効果音を慣らすためにToneライブラリを追加

LedControl lc = LedControl(11, 13, 1);                                         //７セグメントLEDを使うときのオマジナイ
Tone tone1;

void setup(){
    pinMode(A0, INPUT);                                                        //A0ピンを入力にする
    pinMode(A1, INPUT);                                                        //A1ピンを入力にする
    pinMode(A2, INPUT);                                                        //A2ピンを入力にする

    lc.shutdown(0, false);                                                     //７セグメントLEDをリセット
    lc.setIntensity(0, 5);                                                     //色の濃さ
    lc.clearDisplay(0);                                                        //表示クリア
    tone1.begin(8);                                                            //マイコンの8番に接続したスピーカーを使う設定
}

char *sound1 = "M1:d=4,o=5,b=120:16g,16c6";                                    //スイッチ効果音
char *sound2 = "M2:d=4,o=4,b=170:16g,16c5,16p,16g,16c5,16p,16g,16c5,16p,16e5"; //当たりの効果音

int cnt0     = 0;
int cnt1     = 0;
int cnt2     = 0;

int sw0      = 0;
int sw1      = 0;
int sw2      = 0;

void loop(){
//一番左の列の処理
    if(digitalRead(A0) == HIGH){                                                 //もしA0がおされたら
        sw0 = 1;                                                                 //フラグを立てる
        tone1.play_rtttl(sound1);                                                //sound1の楽譜を演奏する
    }
    if(sw0 == 0){                                                                //もしA0がおされていなければ
        cnt0++;                                                                  //カウントアップ
    }
    if(cnt0 > 9){                                                                //もし９よりも大きくなったら
        cnt0 = 0;                                                                //数字をリセット
    }
    //表示
    lc.setDigit(0, 0, cnt0, false);                                              //一番左の列に結果を表示
//左から2番目の列の処理
    if(digitalRead(A1) == HIGH){                                                 //もしA1がおされたら
        sw1 = 1;                                                                 //フラグを立てる
        tone1.play_rtttl(sound1);                                                //sound1の楽譜を演奏する
    }
    if(sw1 == 0){                                                                //もしA1がおされていなければ
        cnt1++;                                                                  //カウントアップ
    }
    if(cnt1 > 9){                                                                //もし９より大きくなったら
        cnt1 = 0;                                                                //数字をリセット
    }
    //表示
    lc.setDigit(0, 1, cnt1, false);                                              //左から2番目の列に結果を表示

//左から３番目の列の処理
    if(digitalRead(A2) == HIGH){                                                 //もしA2がおされたら
        sw2 = 1;                                                                 //フラグを立てる
        tone1.play_rtttl(sound1);                                                //sound1の楽譜を演奏する
    }
    if(sw2 == 0){                                                                //もしA2がおされていなければ
        cnt2++;                                                                  //カウントアップ
    }
    if(cnt2 > 9){                                                                //もし９より大きくなったら
        cnt2 = 0;                                                                //数字をリセット
    }
    //表示
    lc.setDigit(0, 2, cnt2, false);                                              //左から3番目の列に結果を表示

//当たり判定
    if(sw0 == 1 && sw1 == 1 && sw2 == 1 && cnt0 == 7 && cnt1 == 7 && cnt2 == 7){ //もし止まった数字が7であったら
        tone1.play_rtttl(sound2);                                                //sound2の楽譜を演奏する
        while(1);                                                                //ここで終わり（無限ループ）
    }

    delay(100);                                                                  //1/10秒毎 （数字を変えると難易度が変わる）
}
