//-----------------------------------------------------------------------
// スロットマシン１
// 0-9カウンターを回す
// A0でストップをかける
// 音をつける
// 当たりをつける（当たりは7）
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <LedControl.h>
#include <Tone.h>                                                              //効果音を慣らすためにToneライブラリを追加

LedControl lc = LedControl(11, 13, 1);                                         //７セグメントLEDを使うときのオマジナイ
Tone tone1;

void setup(){
    pinMode(A0, INPUT);                                                        //A0ピンを入力にする
    lc.shutdown(0, false);                                                     //７セグメントLEDをリセット
    lc.setIntensity(0, 5);                                                     //色の濃さ
    lc.clearDisplay(0);                                                        //表示クリア
    tone1.begin(8);                                                            //マイコンの8番に接続したスピーカーを使う設定
}

char *sound1 = "M1:d=4,o=5,b=120:16g,16c6";                                    //スイッチ効果音
char *sound2 = "M2:d=4,o=4,b=170:16g,16c5,16p,16g,16c5,16p,16g,16c5,16p,16e5"; //当たりの効果音

int cnt0     = 0;
int sw0      = 0;

void loop(){
    if(digitalRead(A0) == HIGH){                                               //もしA0がおされたら
        sw0 = 1;                                                               //フラグを立てる
        tone1.play_rtttl(sound1);                                              //sound1の楽譜を演奏する
    }
    if(sw0 == 0){                                                              //もしA0がおされていなければ
        cnt0++;                                                                //カウントアップ
    }
    if(cnt0 > 9){                                                              //もし９より大きくなったら
        cnt0 = 0;                                                              //数字をリセット
    }

    lc.setDigit(0, 0, cnt0, false);                                            //一番左の列に結果を表示
    delay(100);                                                                //1/10秒毎

    if(sw0 == 1 && cnt0 == 7){                                                 //もし止まった数字が7であったら
        tone1.play_rtttl(sound2);                                              //sound2の楽譜を演奏する
        while(1);                                                              //ここで終わり（無限ループ）
    }
}
