//-----------------------------------------------------------------------
// スロットマシン１
// 0-9カウンターを回す
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

#include <LedControl.h>

LedControl lc = LedControl(11, 13, 1); //7セグメントLEDを使うときのオマジナイ

void setup(){
    lc.shutdown(0, false);             //７セグメントLEDをリセット
    lc.setIntensity(0, 5);             //色の濃さ
    lc.clearDisplay(0);                //表示クリア
}

int i = 0;

void loop(){
    i++;                               //カウントアップ
    if(i > 9){                         //もし９より大きくなったら
        i = 0;                         //数字をリセット
    }
    lc.setDigit(0, 0, i, false);       //一番左の列に結果を表示
    delay(100);                        //1/10秒毎
}
