//-----------------------------------------------------------------------
// 超音波距離センサーを用いたカウンター
// US1スタート
// US2ストップ
// 前を通り過ぎたもののかかった時間を計測する
// STEP1 カウントする
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

#include <LedControl.h>
#include "RPlib.h"

LedControl lc = LedControl(11, 13, 1); //7セグメントLEDを使うときのオマジナイ

void setup(){
    lc.shutdown(0, false);             //7セグメントLEDをリセット
    lc.setIntensity(0, 5);             //色の濃さ
    lc.clearDisplay(0);                //表示クリア

    ussRead(US1);
    ussRead(US2);
    delay(500);
}

int i;
void loop(){
    lc.setDec(0, i);                   //7セグメントLEDに結果を表示
    delay(10);
    i++;                               //カウントアップ
}
