//-----------------------------------------------------------------------
// 超音波距離センサーを用いたカウンター
// US1の前を通り過ぎたものの数を数える
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

#include <LedControl.h>
#include "RPlib.h"

LedControl lc = LedControl(11, 13, 1);                //７セグメントLEDを使うときのオマジナイ

void setup(){
    lc.shutdown(0, false);                            //７セグメントLEDをリセット
    lc.setIntensity(0, 5);                            //色の濃さ
    lc.clearDisplay(0);                               //表示クリア
}

int i, d;
void loop(){
    d = ussRead(US1);
    if(d < 20 && d > 3){                              //もしUS1に反応があったら
        i++;                                          //カウントアップ
        while(d < 20 && d > 3){ //反応している間はストップ
            delay(500);
            d = ussRead(US1);
        }
    }
    lc.setDec(0, i);                                  //７セグメントLEDに結果を表示
}
