//-----------------------------------------------------------------------
// 2つのLEDと2つのスイッチを使いこなすプログラム
// 4番7番は入力、8番11番は出力設定
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

void setup(){
    pinMode(4, INPUT);           //4番は入力（スイッチ）
    pinMode(7, INPUT);           //7番は入力（スイッチ）
    pinMode(8, OUTPUT);          //8番は出力（LED）
    pinMode(11, OUTPUT);         //11番は出力（LED）
}

void loop(){
    if(digitalRead(4) == HIGH){  //4番のスイッチの判定
        digitalWrite(8, HIGH);   //8番のLEDを点灯
    }
    else{
        digitalWrite(8, LOW);    //8番のLEDを消灯
    }

    if(digitalRead(7) == HIGH){  //7番のスイッチの判定
        digitalWrite(11, HIGH);  //11番のLEDを点灯
    }
    else{
        digitalWrite(11, LOW);   //11番のLEDを消灯
    }
}
