//-----------------------------------------------------------------------
// ポート5スイッチを押すとマイコンボードのポート8を点灯しスピーカを鳴らす
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
int sw  = 5;                     //sw(スイッチ）という名の変数を用意する(sw=5)
int led = 8;                     //ledという名の変数を用意する(led=8)

void setup(){
    pinMode(sw, INPUT);          //sw(スイッチ)を入力に設定する
    pinMode(led, OUTPUT);        //ledを出力に設定する
}

void loop(){
    if(digitalRead(sw) == HIGH){ //if文「スイッチがオンされたら」
        digitalWrite(led, HIGH); //LEDが点灯（出力）
        tone(A5, 200, 10);       //スピーカーがラの音を出す（出力）
    }
    else{                        //そうでなければ
        digitalWrite(led, LOW);  //LEDは消灯
    }
}
