#include "Wire.h"
#include "I2Cdev.h"
#include "MPU6050.h"
#include <Tone.h>     //Tone_baseから移植した部分
#include <RPlib.h>    //Tone_baseから移植した部分

Tone spk;             //Tone_baseから移植した部分

int16_t ax, ay, az;
int16_t gx, gy, gz;
int16_t mx, my, mz;
int16_t temp;

MPU6050 accelgyro;
bool blinkState = false;

void setup(){
    Wire.begin();
    Serial.begin(115200);
    
    Serial.println("Initializing I2C devices...");
    accelgyro.initialize();
    accelgyro.setFullScaleAccelRange(MPU6050_ACCEL_FS_16);
    
    Serial.println("Testing device connections...");
    Serial.println(accelgyro.testConnection() ? "MPU6050 connection successful" : "MPU6050 connection failed");
    pinMode(13, OUTPUT);
    spk.begin(D2);    //Tone_baseから移植した部分

}

int freq;

void loop(){
  
    //姿勢検出シールドのセンサーの値をチェックし、各変数に記録する
    accelgyro.getMotion9(&ax, &ay, &az, &gx, &gy, &gz, &mx, &my, &mz);

    //センサーの値を記録した各変数の値を、シリアルモニタに表示する
    //ax～azは加速度センサ、gx～gzは各速度センサ、一番最後は温度センサ（『気温』ではなく『センサーの温度』になることに注意）
    Serial.print("a/g/T:\t");
    Serial.print(ax); Serial.print("\t");
    Serial.print(ay); Serial.print("\t");
    Serial.print(az); Serial.print("\t");
    Serial.print(gx); Serial.print("\t");
    Serial.print(gy); Serial.print("\t");
    Serial.print(gz); Serial.print("\t");
    Serial.println(accelgyro.getTemperature() / 333.87 + 21);

    //マイコンボード上のLEDを点滅させる（動作チェック用）
    blinkState = !blinkState;
    digitalWrite(13, blinkState);
    
    //xyz軸それぞれ、加速度を「周波数にするとイイカンジの値」に直していく
    //① 絶対値とってマイナスを消す（今回は三平方の過程で二乗するため実は不要）
    //② あまり大きな値域は外す（上限値を各方向4000までに設定）
    ax = abs(ax);
    ay = abs(ay);
    az = abs(az);
    ax = constrain(ax, 0, 4000);
    ay = constrain(ay, 0, 4000);
    az = constrain(az, 0, 4000);
    //3軸の値をpow関数で二乗して足し、sqrtで平方根を取る（三平方の定理）。
    freq = sqrt(pow(ax, 2) + pow(ay, 2) + pow(az, 2));
    //周波数（最大1200Hz）の範囲内に当てはまるようマッピング
    //なおこの時点でのfreqの最大値（ax～azが全て4000のとき）は約6928なので、変換前の値の範囲を0～7000とする
    freq = map(freq, 0, 7000, 0, 1200);

    spk.play(freq,500);    //Tone_baseから移植した部分（ここから下すべて）
    delay(50);
    spk.stop();
    delay(500);
}
