//-----------------------------------------------------------------------
// 　LED line 回転(プロペラ)
//  ジャイロバージョン
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

//ライブラリを取り込む
#include <Sprite.h>
#include <Matrix.h>
#include "Wire.h"
#include <math.h>
#include "I2Cdev.h"
#include "MPU6050.h"

Matrix myMatrix = Matrix(11, 13, 1); //マトリクスLEDを使用するオマジナイ
MPU6050 accelgyro;                   //姿勢センサーを使うときのオマジナイ
int16_t ax, ay, az;
int16_t gx, gy, gz;
int16_t mx, my, mz;
long ave = 0;
float temp;

void setup(){
    myMatrix.clear();        //マトリクスLEDの表示を消す
    //-----------  姿勢センサーの準備
    Wire.begin();
    accelgyro.initialize();  //姿勢センサーの準備

    //-------  ジャイロ初期値計測
    for(int i = 0; i < 500; i++){
        myMatrix.line(0,i % 8,7,i % 8);                                    //座標(x1,y1)から座標(x2,y2)へ線を引く
        accelgyro.getMotion9(&ax, &ay, &az, &gx, &gy, &gz, &mx, &my, &mz); //姿勢センサーの検出
        ave += gz;
        myMatrix.clear();
    }
    ave /= 500;
}

int x1,x2,y1,y2;  //始点と終点に使うx・y座標を用意
int dtime;        //LEDが移動する待ち時間
float ang = 0;

void loop(){

    //y軸に沿ってラインが動く
    x1 = 0;
    x2 = 7;


    for(int y = 0; y <= 7; y++){
        y1 = y;
        y2 = 7 - y;
        myMatrix.line(x1,y1,x2,y2);                                        //座標(x1,y1)から座標(x2,y2)へ線を引く
        accelgyro.getMotion9(&ax, &ay, &az, &gx, &gy, &gz, &mx, &my, &mz); //姿勢センサーの検出
        ang += (( gz - ave ) / 16.4 / 8 ) / 100 * 2.8;
        dtime = map(constrain(ang,0,180), 0,180,1,400);
        delay(dtime);
        myMatrix.clear();
    }

    //x軸に沿ってラインが動く
    y1 = 7;
    y2 = 0;

    for(int x = 1; x <= 6; x++){
        x1 = x;
        x2 = 7 - x;
        myMatrix.line(x1,y1,x2,y2);                                        //座標(x1,y1)から座標(x2,y2)へ線を引く
        accelgyro.getMotion9(&ax, &ay, &az, &gx, &gy, &gz, &mx, &my, &mz); //姿勢センサーの検出
        ang += (( gz - ave ) / 16.4 / 8 ) / 100 * 2.8;
        dtime = map(constrain(ang,0,180), 0,180,1,400);
        delay(dtime);
        myMatrix.clear();
    }
}
