//
//　姿勢センサーの値を７セグメントLEDで表示する
//　ｘ軸方向の角速度を測ろう
//　角速度に応じて音が出る
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <LedControl.h>
#include "Wire.h"
#include <math.h>
#include "I2Cdev.h"
#include "MPU6050.h"
#include <RPlib.h>

LedControl lc = LedControl(11,13,1); //７セグメントLEDを使うときのオマジナイ

MPU6050 accelgyro;                   //姿勢センサーを使うときのオマジナイ

int16_t ax, ay, az;
int16_t gx, gy, gz;
int16_t mx, my, mz;


void setup(){
    //------------ 7セグメントLEDの準備
    lc.shutdown(0,false);                                  //７セグメントLEDをリセット
    lc.setIntensity(0,8);                                  //色の濃さ
    lc.clearDisplay(0);                                    //表示クリア
    //-----------  姿勢センサーの準備
    Wire.begin();
    accelgyro.initialize();                                //姿勢センサーの準備
    accelgyro.setFullScaleGyroRange(MPU6050_GYRO_FS_2000); //最大レンジ変更2000deg/sec
}

void loop(){

    accelgyro.getMotion9(&ax, &ay, &az, &gx, &gy, &gz, &mx, &my, &mz); //姿勢センサーの検出
    tone(D1,abs((int)gx / 16.4));                                      //absは絶対値
    lc.setDec(0,gx / 16.4);                                            //x軸まわりの回転角速度をLEDに表示(deg/s)
    delay(abs((int)gy / 16.4));
}
