//
// 姿勢センサーの値を7セグメントLEDで表示する
// z軸方向のGを測ろう
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <LedControl.h>
#include "Wire.h"
#include <math.h>
#include "I2Cdev.h"
#include "MPU6050.h"

LedControl lc = LedControl(11,13,1); //7セグメントLEDを使うときのオマジナイ

MPU6050 accelgyro;                   //姿勢センサーを使うときのオマジナイ

int16_t ax, ay, az;
int16_t gx, gy, gz;
int16_t mx, my, mz;
float temp;

void setup(){
//------------ 7セグメントLEDの準備
    lc.shutdown(0,false);                                  //７セグメントLEDをリセット
    lc.setIntensity(0,8);                                  //色の濃さ
    lc.clearDisplay(0);                                    //表示クリア
//-----------  姿勢センサーの準備
    Wire.begin();
    accelgyro.initialize();                                //姿勢センサーの準備
    accelgyro.setFullScaleAccelRange(MPU6050_ACCEL_FS_16); //加速度計のレンジを調整(最大検出)
}

void loop(){

    accelgyro.getMotion9(&ax, &ay, &az, &gx, &gy, &gz, &mx, &my, &mz); //姿勢センサーの検出
    temp = accelgyro.getTemperature() / 333.87 + 21;                   //温度検出

    lc.setDec(0,az / 20);                                              //z軸の加速度を7セグメントLEDに表示
    delay(500);
}
