// 姿勢センサーの値に応じてドットが動く
//
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <Sprite.h>        // Sprite before Matrix
#include <Matrix.h>
#include "Wire.h"
#include <math.h>
#include "I2Cdev.h"
#include "MPU6050.h"

Matrix myMatrix = Matrix(11, 13, 1);

MPU6050 accelgyro;        //姿勢センサーを使うときのオマジナイ

int16_t ax, ay, az;
int16_t gx, gy, gz;
int16_t mx, my, mz;
float temp;

void setup(){

    myMatrix.clear();        //マトリクスLEDの表示を消す
//-----------  姿勢センサーの準備
    Wire.begin();
    accelgyro.initialize();  //姿勢センサーの準備
}

int x,y;
void loop(){

    accelgyro.getMotion9(&ax, &ay, &az, &gx, &gy, &gz, &mx, &my, &mz); //姿勢センサーの検出


    x = map(ax,-16000,16000,0,7);                                      //0-7の間にする
    y = map(ay,-16000,16000,7,0);                                      //0-7の間にする


    myMatrix.write(x, y, HIGH);                                        //LEDを点灯
    delay(50);
    myMatrix.write(x, y,LOW);                                          //LEDを消す
}
