//アップダウンカウンター
// U2でアップ
//-------------------------------

#include <LedControl.h>
LedControl lc = LedControl(11,13,1);        //７セグを使うためのオマジナイ

// A相ピン割り当て
#define ENC0_A 9
#define ENC1_A A2
#define ENC2_A 10

// B相ピン割り当て
#define ENC0_B 0
#define ENC1_B A3
#define ENC2_B 12

void setup(){
    lc.shutdown(0,false);      //７セグをリセット
    lc.setIntensity(0,3);      //色の濃さ
    lc.clearDisplay(0);        //表示クリア

    pinMode(ENC0_A, INPUT);
    pinMode(ENC0_B, INPUT);
    pinMode(ENC1_A, INPUT);
    pinMode(ENC1_B, INPUT);
    pinMode(ENC2_A, INPUT);
    pinMode(ENC2_B, INPUT);
    lc.setDec(0,0);            //初期表示
}

int count = 0;
void loop(){
    if(digitalRead(ENC1_B) == LOW){
        delay(100);
        lc.setDec(0,++count);
    }
    delay(10);
}
