//-----------------------------------------------------------------------
// マウスオムニボット　迷路脱出プログラム　
// (ゴールの処理も付いています)
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

#include <RPomniDirect.h>
#include <RPlib.h>
#include <LedControl.h>
#include <ColorSensor.h>
#include <Tone.h>
Tone tone1;

//曲データ2
char *sound2  = "M2A:d=4,o=6,b=180:16g,16c7,16f7,16p,16c7,16d7,16g7,16p,16g,16c7,16d7,16f7,16g7,16d7,16c7,16d7";
int rx[]      = {0, 1, 2, 3, 3, 3, 3, 2, 1, 0, 0, 0};
int ry[]      = {1, 1, 1, 1, 2, 5, 0, 0, 0, 0, 4, 6};

LedControl lc = LedControl(11, 13, 1);                              //7セグメントLEDを使うためのおまじない
RPomniDirect omniBot(1.0f, 1.0f, 1.0f, 0.0f, MC3, MC1, MC2);        //以前の調整データを使ってね

void setup(){
    tone1.begin(D2);                                                //D2にスピーカーを接続
    lc.shutdown(0, false);                                          //７セグメントLED　リセット
    lc.setIntensity(0, 4);                                          //７セグメントLED　色の濃さ設定
    lc.clearDisplay(0);                                             //７セグメントLED　表示をクリア
    ColorSensor.begin(4000, 0);                                     //カラーセンサーの積分時間を指定 x0.1[ms]　 値が大きいほどセンサー値の精度が良くなるが、そのぶん時間がかかる　6000で600[ms] 最大 6144
    for (int i = 4; i < 8; i++) ColorSensor.ledOn(i);               //照明用LEDの点灯
    ColorSensor.ledRGB(0, 0, 0);                                    //フルカラーLEDは消灯

    int dist1 = ussRead(US1);                                       //超音波距離センサーUS1の読み込み
    int dist2 = ussRead(US2);                                       //超音波距離センサーUS2の読み込み
    delay(100);
}

void loop(){
    int dist1 = ussRead(US1);
    int dist2 = ussRead(US2);

    if (dist2 > 10){                                                //場合３と場合４：右に壁がないとき
        lc.setDec(0, 3);                                            //場合番号を表示
        omniBot.move(0, 20, 17);                                    //右側に壁を探して右カーブ走行
    }
    else if (dist1 > 6){                                            //場合２：(右に壁があって、)前が開けているとき
        lc.setDec(0, 2);                                            //場合番号を表示
        omniBot.move(0, 20, constrain(( dist2 - 8 ) * 3, -10, 10)); //壁から8センチを保って前進
    }
    else{                                                           //場合１：(右に壁があって、)前に壁があるとき
        lc.setDec(0, 1);                                            //場合番号を表示
        omniBot.move(0, 0, -20);                                    //その場で左回転
        while (ussRead(US1) < 20 || ussRead(US2) > 10) delay(100);  //前方が20センチ以上開けていて右10センチの範囲に壁が見えるまで回転を継続
        delay(600);
    }

    //カラーセンサーの処理
    if (ColorSensor.colorRead()){                                   //カラーセンサーの読み込み
        word clear = ColorSensor.colorClear();                      //カラーセンサーの数値初期化
        word red   = ColorSensor.colorRed();                        //カラーセンサーの赤要素検出
        word green = ColorSensor.colorGreen();                      //カラーセンサーの緑要素検出
        word blue  = ColorSensor.colorBlue();                       //カラーセンサーの青要素検出

        ColorSensor.convertHSV(red, green, blue);                   //RGBデータをHSVデータに変更する
        word h = ColorSensor.convertH();
        word s = ColorSensor.convertS();
        word v = ColorSensor.convertV();

        if (h >= 100 && h <= 140){                                  //緑(H=120)を検出
            //ゴールの処理
            omniBot.move(0, 0, 0);                                  //ロボットを停止
            lc.setDec(0, h);                                        //H値を７セグメントLEDで表示する
            goal(3, 2);                                             //ここでは　LED光の回転回数、演奏回数を指定して歓喜のパフォーマンス
        }
    }

    delay(100);
}

//-------------------- オリジナル関数
void goal(int lnum, int snum){                                      //ひとつめの引数はLEDの回転回数、ふたつ目の引数はメロディの回数
    for (int k = 0; k < snum; k++){                                 //メロディを指定回数だけ鳴らす
        tone1.play_rtttl(sound2);                                   //sound2の曲を流す
        delay(500);
    }

    lc.clearDisplay(0);                                             //７セグメントLEDの表示をクリア

    for (int j = 0; j < lnum; j++){                                 //LEDの光を指定回数だけ回転させる
        for (int i = 0; i < 12; i++){
            lc.setLed(0, rx[i], ry[i], HIGH);
            delay(100);
            lc.setLed(0, rx[i], ry[i], LOW);
        }
    }
}
