//-----------------------------------------------------------------------
// 迷路脱出プログラム
// Case1～3を統合
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

#include <RPomniDirect.h>
#include <RPlib.h>
#include <LedControl.h>

LedControl lc = LedControl(11, 13, 1);                              //７セグメントLEDを使うためのオマジナイ
RPomniDirect omniBot(1.0f, 1.0f, 1.0f, 0.0f, MC3, MC1, MC2);        //以前の調整データを使ってね

void setup(){
    lc.shutdown(0, false);                                          //７セグメントLED　リセット
    lc.setIntensity(0, 4);                                          //７セグメントLED　色の濃さ設定
    lc.clearDisplay(0);                                             //７セグメントLED　表示をクリア

    int dist1 = ussRead(US1);                                       //超音波距離センサーUS1検知
    int dist2 = ussRead(US2);                                       //超音波距離センサーUS2検知
    delay(500);
}

void loop(){
    int dist1 = ussRead(US1);                                       //超音波距離センサーUS1検知
    int dist2 = ussRead(US2);                                       //超音波距離センサーUS2検知

    if (dist1 <= 6 && dist2 <= 10){                                 //前方の壁まで6センチ以下、右の壁まで10センチ以下のとき
        lc.setDec(0, 1);                                            //ケースナンバーを表示
        omniBot.move(0, 0, -20);                                    //左回転
        while (ussRead(US1) < 20 || ussRead(US2) > 10)              //前方が20センチ以上開けていて右10センチの範囲に壁が見えるまで回転を継続
        delay(600);                                                 //***調整箇所*** ロボットが正面を向くように値を調整します。
    }
    else if (dist1 > 4 && dist2 <= 12){                             //前が4センチより開けていて、右側の壁まで12センチ以下のとき
        lc.setDec(0, 2);                                            //ケースナンバーを表示
        //右の壁との距離を8センチに保って走ることを考えます
        if (dist2 == 8){                                            //(右の壁まで12センチ以下で、)距離が8センチのとき
            omniBot.move(0, 20, 0);                                 //直進
        }
        else if (dist2 > 8){                                        //(右の壁まで12センチ以下で、)8センチより大きいとき
            omniBot.move(0, 20, 3);                                 //右カーブしつつ前進(壁との距離を近づける)
        }
        else{                                                       //(右の壁まで12センチ以下で、)8センチ未満のとき
            omniBot.move(0, 20, -3);                                //左カーブしつつ前進(壁との距離を遠ざける)
        }
    }
    else{
        lc.setDec(0, 3);                                            //ケースナンバーを表示
        omniBot.move(0, 20, 10);                                    //右側の壁を探して右カーブ走行
        delay(400);
    }
    delay(10);
}
