//-----------------------------------------------------------------------
// パターン２:　右側(US2)に壁
// 右側の壁に沿って進む
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

#include <RPomniDirect.h>
#include <RPlib.h>
#include <LedControl.h>

LedControl lc = LedControl(11, 13, 1);                        //７セグメントLEDを使うためのオマジナイ
RPomniDirect omniBot(0.85f, 1.0f, 1.0f, 0.0f, MC3, MC1, MC2); //以前の調整データを使ってね

void setup(){
    lc.shutdown(0, false);                                    //７セグメントLED　リセット
    lc.setIntensity(0, 4);                                    //７セグメントLED　色の濃さ設定
    lc.clearDisplay(0);                                       //７セグメントLED　表示をクリア
    //準備動作
    ussRead(US1);                                             //前方センサー検知
    ussRead(US2);                                             //右側センサー検知
    delay(500);
}

void loop(){
    int dist1 = ussRead(US1);
    int dist2 = ussRead(US2);

    if (dist1 > 4 && dist2 <= 12){                            //もし前が4センチより開けていて、かつ右側の壁まで12センチ以下なら
        //右の壁との距離を8センチに保って走ることを考えます
        if (dist2 == 8){                                      //(右の壁まで12センチ以下で、)距離が8センチのとき
            omniBot.move(0, 20, 0);                           //ロボットは直進
        }
        else if (dist2 > 8){                                  //(右の壁まで12センチ以下で、)8センチより大きいとき
            omniBot.move(0, 20, 3);                           //右カーブしつつ前進(壁との距離を近づける)
        }
        else{                                                 //(右の壁まで12センチ以下で、)8センチ未満のとき
            omniBot.move(0, 20, -3);                          //左カーブしつつ前進(壁との距離を遠ざける)
        }
    }
    else{                                                     //前が開けていない、または、右の壁までの距離が10センチより遠いとき
        omniBot.move(0, 0, 0);                                //停止
    }

    delay(100);
}
