//-----------------------------------------------------------------------
// カラーセンサーのテスト
// 選んだ色の色相を確認しよう
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

#include <ColorSensor.h>
#include <LedControl.h>
LedControl lc = LedControl(11, 13, 1);                //７セグメントLEDを使うためのオマジナイ

void setup(){
    lc.shutdown(0, false);                            //７セグメントLEDをリセット
    lc.setIntensity(0, 8);                            //色の濃さ
    lc.clearDisplay(0);                               //表示クリア
    ColorSensor.begin(4000, 0);                       //カラーセンサーの積分時間を指定 x0.1[ms]　 値が大きいほどセンサー値の精度が良くなるが、そのぶん時間がかかる　6000で600[ms] 最大 6144
    for(int i = 4; i < 8; i++) ColorSensor.ledOn(i);  //カラーセンサーLEDの点灯
}

void loop(){
    if (ColorSensor.colorRead()){                     //色センサーの読み込み
        word clear = ColorSensor.colorClear();        //色センサーの数値初期化

        word red   = ColorSensor.colorRed();          //色センサーの赤要素検出
        word green = ColorSensor.colorGreen();        //色センサーの緑要素検出
        word blue  = ColorSensor.colorBlue();         //色センサーの青要素検出

        ColorSensor.convertHSV(red, green, blue);     //RGBデータをHSVデータに変更する
        word h = ColorSensor.convertH();
        word s = ColorSensor.convertS();
        word v = ColorSensor.convertV();

        lc.setDec(0, h);                              //H値を７セグメントLEDで表示する

        delay(100);
    }
}
