//-----------------------------------------------------------------------
// STEP1
//回り続けて、二つの超音波距離センサーの距離情報を取り続ける。
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <RPomniDirect.h>
#include <RPlib.h>
#include <LedControl.h>
//１、２、３のモーター番号通りに組んであれば以前使った調整値がそのまま使えます。
//わからなくなってしまった場合はもう一度アジャストプログラムを走らせる必要があります。
RPomniDirect omniBot(1.0f,1.0f,1.0f,50.0f);
LedControl lc = LedControl(11,13,1); //おまじない

void setup(){
    lc.shutdown(0,false);            //７セグLED　リセット
    lc.setIntensity(0,4);            //７セグLED　色の濃さ設定
    lc.clearDisplay(0);              //７セグLED　表示をクリア
    //準備動作
    ussRead(US1);                    //前センサ検出
    ussRead(US2);                    //後ろセンサ検出
    delay(500);
}

int d1 = 0;
int d2 = 0;
void loop(){
    d1 = ussRead(US1);               //センサーUS1(前方)検知
    d2 = ussRead(US2);               //センサーUS2(後方)検知

    omniBot.move(0,0,30);            //回転する

    lc.setDec(0,min(d1,d2));         //距離が小さい方の超音波距離センサーの値を表示する
    delay(100);
}
