/*!
 * @file ColorSensor.ino
 * @brief カラーセンサから取得できたRGB(赤、緑、青)の信号値をHSV変換したののち、色相(h:Hue)のみをカラーLEDで表示するサンプルプログラム
 * 電源投入時には、カラーセンサーをなるべく何もない空間に向けておくこと
 *
 * Copyright (c) 2014 Future Robotics Technology Center (fuRo), Masaharu Shimizu All rights reserved.<BR>
 *
 * @date Created on: 2014/07/10
 * @author Masaharu Shimizu@@fuRo
 */

#include <ColorSensor.h>

void setup(){
    Serial.begin(9600);
    ColorSensor.begin(1000, 0);        // カラーセンサの積分時間を指定 x0.1[ms]　 値が大きいほどセンサ値の精度が良くなるが、そのぶん時間がかかる　6000で600[ms] 最大 6144
}

void loop(){
    if (ColorSensor.colorRead()){
        word clear = ColorSensor.colorClear();

        word red   = ColorSensor.colorRed();
        word green = ColorSensor.colorGreen();
        word blue  = ColorSensor.colorBlue();

        ColorSensor.convertHSV(red, green, blue);
        word h = ColorSensor.convertH();
        word s = ColorSensor.convertS();
        word v = ColorSensor.convertV();

        ColorSensor.convertRGB(h);
        byte ledR = ColorSensor.convertRed();
        byte ledG = ColorSensor.convertGreen();
        byte ledB = ColorSensor.convertBlue();

        if(s > 7){
            ColorSensor.ledRGB(ledR, ledG, ledB);
        }
        else {
            ColorSensor.ledRGB(0, 0, 0);
        }

        Serial.print("colorRed:");
        Serial.print(red);
        Serial.print(" colorGreen:");
        Serial.print(green);
        Serial.print(" colorBlue:");
        Serial.print(blue);
        Serial.print(" colorClear:");
        Serial.print(clear);

        Serial.print(" H:");
        Serial.print(h);
        Serial.print(" S:");
        Serial.print(s);
        Serial.print(" V:");
        Serial.print(v);

        Serial.print(" ledR:");
        Serial.print(ledR);
        Serial.print(" ledG:");
        Serial.print(ledG);
        Serial.print(" ledB:");
        Serial.println(ledB);

        delay(100);
    }
}
