//-----------------------------------------------------------------------
// 自動搬送①(対象物までの距離の測定)
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <RPlib.h>
#include <VarSpeedServo.h>
#include <ArmRobot.h>
#include <Ultrasonic.h>

Ultrasonic ultrasonic(US1);                            //超音波距離センサーのインスタンスを生成
ArmRobot armBot;                                       //アームロボットを使うときのオマジナイ

void setup(){
    Serial.begin(9600);                                //シリアル通信を使うときのオマジナイ
    pinMode(D3,INPUT_PULLUP);                          //スタートボタンの設定
    while(!digitalRead(D3));
    Serial.println("Initialization....");              //Initializationは初期化という意味
    /***********************************/
    armBot.setup(0.0,0.0,0.0,0.0);                     //調整値(servoR,servoL,servoROT,servoGRIPの順)
    /***********************************/
    delay(3000);
    while(!digitalRead(D3));
    Serial.println("move to initial position.");
    armBot.setServoSpeed(SERVO_R,   10);               //0=full speed, 1-255 slower to faster
    armBot.setServoSpeed(SERVO_L,   10);               //0=full speed, 1-255 slower to faster
    armBot.setPosition(150,50,0);
    delay(1000);
    armBot.setServoSpeed(SERVO_R,   20);               //0=full speed, 1-255 slower to faster
    armBot.setServoSpeed(SERVO_L,   20);               //0=full speed, 1-255 slower to faster
    armBot.setServoSpeed(SERVO_ROT,   20);             //0=full speed, 1-255 slower to faster
}

void loop(){
    float mm;
    long microsec = ultrasonic.timing();               //センサー情報を計測
    mm = ultrasonic.convert(microsec, Ultrasonic::MM); //センサー情報を変換

    //距離をシリアルで表示
    Serial.print("distance: ");
    Serial.println(mm);
    delay(100);
}
