//-----------------------------------------------------------------------
// サーボモーターのテスト(writeMicroseconds命令)
// 1856段階で制御
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
//ライブラリの読み込み
#include <RPlib.h>
#include <Servo.h>
#define ORIGIN 1500
#define RANGE 600

Servo servo;                  ////サーボモーターを使うときのオマジナイ(servoと名づける)

void setup(){
    pinMode(D3,INPUT_PULLUP); //D3にタッチセンサーを接続
    while(!digitalRead(D3));  //D3に接続されたタッチセンサーを読み取る
    servo.attach(S0);         //サーボモーターをS0に接続
    delay(500);
}

void loop(){
    while(!digitalRead(D3));                         //D3に接続されたタッチセンサーを読み取る

    for(int us = 0; us < RANGE / 2; us++){
        servo.writeMicroseconds(us + ORIGIN);        //0-180まで
        delay(5);
    }

    for(int us = RANGE / 2; us >= -RANGE / 2; us--){
        servo.writeMicroseconds(us + ORIGIN);        //0-180まで
        delay(5);
    }

    for(int us = -RANGE / 2; us <= 0; us++){
        servo.writeMicroseconds(us + ORIGIN);        //0-180まで
        delay(5);
    }
}
