//-----------------------------------------------------------------------
// アームの動作確認と初期値の調整
// D3のタッチセンサーをおすとスタート
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
//ライブラリを読み込む
#include <RPlib.h>
#include <VarSpeedServo.h>

#define ORIGIN 90             //原点位置
#define RANGE 30
#define ADJUST_SERVO_R 0.0    //S0はここで調整(-で前)
#define ADJUST_SERVO_L 0.0    //S1はここで調整(-で前)
#define ADJUST_SERVO_ROT 0.0  //S2はここで調整(+で左旋回)
#define ADJUST_SERVO_HAND 0.0 //S3はここで調整(+でオープン)


VarSpeedServo myservo0;       //サーボモーターを使うときのオマジナイ(myservo0と名づける)
VarSpeedServo myservo1;       //サーボモーターを使うときのオマジナイ(myservo1と名づける)
VarSpeedServo myservo2;       //サーボモーターを使うときのオマジナイ(myservo2と名づける)
VarSpeedServo myservo3;       //サーボモーターを使うときのオマジナイ(myservo3と名づける)

int pos = 0;                  //変数intをposという名前で使う(はじめは0)

void setup(){
    pinMode(D3,INPUT_PULLUP);                                     //D3にタッチセンサーを接続

    while(!digitalRead(D3));                                      //D3に接続されたタッチセンサーを読み取る

    myservo0.attach(S0,SERVO_MG995_MIN,SERVO_MG995_MAX);          //myservo0と名づけたモーターをS0に接続
    delay(500);
    myservo1.attach(S1,SERVO_MG995_MIN,SERVO_MG995_MAX);          //myservo1と名づけたモーターをS1に接続
    delay(500);
    myservo2.attach(S2,SERVO_MG995_MIN,SERVO_MG995_MAX);          //myservo2と名づけたモーターをS2に接続
    delay(500);
    myservo3.attach(S3,SERVO_SG90_MIN,SERVO_SG90_MAX);            //myservo3と名づけたモーターをS3に接続
    delay(500);

    while(!digitalRead(D3));                                      //D3に接続されたタッチセンサーを読み取る

    for(pos = 0; pos <= RANGE; pos++){                            //0度から-RANGE度まで(1度ずつ)
        myservo0.write(ADJUST_SERVO_R * pos / RANGE + ORIGIN);    //writeで角度を指定(変数posの値で動く)
        myservo1.write(ADJUST_SERVO_L * pos / RANGE + ORIGIN);    //writeで角度を指定(変数posの値で動く)
        myservo2.write(ADJUST_SERVO_ROT * pos / RANGE + ORIGIN);  //writeで角度を指定(変数posの値で動く)
        myservo3.write(ADJUST_SERVO_HAND * pos / RANGE + ORIGIN); //writeで角度を指定(変数posの値で動く)
        delay(50);                                                //50ミリ秒待つ
    }
}

void loop(){
}
