//-----------------------------------------------------------------------
// アームロボットのモーション確認テスト
// D3のタッチセンサーをおすとスタート
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
//ライブラリを読み込む
#include <RPlib.h>
#include <VarSpeedServo.h>
#define ORIGIN 90       //原点位置
#define RANGE 25
VarSpeedServo myservo0; //サーボモーターを使うときのオマジナイ(myservo0と名づける)
VarSpeedServo myservo1; //サーボモーターを使うときのオマジナイ(myservo1と名づける)
VarSpeedServo myservo2; //サーボモーターを使うときのオマジナイ(myservo2と名づける)

int pos = 0;            //変数intをposという名前で使う(はじめは0)

void setup(){
    pinMode(D3, INPUT_PULLUP);                             //D3にタッチセンサーを接続

    while (!digitalRead(D3));                              //D3に接続したタッチセンサーを読み取る

    myservo0.attach(S0, SERVO_MG995_MIN, SERVO_MG995_MAX); //myservo0と名づけたモーターをS0に接続
    delay(500);
    myservo1.attach(S1, SERVO_MG995_MIN, SERVO_MG995_MAX); //myservo1と名づけたモーターをS1に接続
    delay(500);
    myservo2.attach(S2, SERVO_MG995_MIN, SERVO_MG995_MAX); //myservo2と名づけたモーターをS2に接続
    delay(500);

    for (pos = 0; pos >= -RANGE; pos -= 1){                //0度から-RANGE度まで(1度ずつ)
        myservo0.write(pos + ORIGIN);                      //writeで角度を指定(変数posの値で動く)
        myservo1.write(pos + ORIGIN);                      //writeで角度を指定(変数posの値で動く)
        myservo2.write(pos + ORIGIN);                      //writeで角度を指定(変数posの値で動く)
        delay(50);                                         //50ミリ秒待つ
    }
}

void loop(){
    while (!digitalRead(D3));                   //D3に接続されたタッチセンサーを読み取る
    for (pos = -RANGE; pos < RANGE; pos += 1){  //-RANGE度からRANGE度まで(1度ずつ)
        myservo0.write(pos + ORIGIN);           //writeで角度を指定(変数posの値で動く)
        myservo1.write(pos + ORIGIN);           //writeで角度を指定(変数posの値で動く)
        myservo2.write(pos + ORIGIN);           //writeで角度を指定(変数posの値で動く)
        delay(50);                              //50ミリ秒待つ
    }
    for (pos = RANGE; pos >= -RANGE; pos -= 1){ //RANGE度から-RANGE度まで(1度ずつ)
        myservo0.write(pos + ORIGIN);           //writeで角度を指定(変数posの値で動く)
        myservo1.write(pos + ORIGIN);           //writeで角度を指定(変数posの値で動く)
        myservo2.write(pos + ORIGIN);           //writeで角度を指定(変数posの値で動く)
        delay(50);                              //50ミリ秒待つ
    }
}
