//-----------------------------------------------------------------------
// サーボモーター(S3)の動作確認
// ハンドの開閉テスト
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
//ライブラリの読み込み
#include <RPlib.h>
#include <VarSpeedServo.h>

#define ORIGIN 90
#define RANGE 35
VarSpeedServo myservo3; //サーボモーターを使うときのオマジナイ(myservo3と名づける)

int pos = 0;            //変数intをposという名前で使う(はじめは0)

void setup(){
    myservo3.attach(S3,SERVO_SG90_MIN,SERVO_SG90_MAX);        //myservo3と名づけたモーターをS3に接続
}

void loop(){
    myservo3.write(ORIGIN - RANGE); //サーボモーター(myservo3)のホーン角度を「ORIGIN-RANGE」度まで回転
    delay(2000);
    myservo3.write(ORIGIN);         //サーボモーター(myservo3)のホーン角度を「ORIGIN」度まで回転
    delay(2000);
    myservo3.write(ORIGIN + RANGE); //サーボモーター(myservo3)のホーン角度を「ORIGIN+RANGE」度まで回転
    delay(2000);
}
