//-----------------------------------------------------------------------
//シリアルモニターを使ってコントローラーの動作のチェックをする
//
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
//ライブラリを読み込む
#include <PS2X_lib.h>

PS2X ps2x;

int vibrate = 0;                                     //変数初期化　コントローラーでつかう

void setup(){
    ps2x.config_gamepad(13, 11, 10, 12, true, true); //コントローラーを使用するおまじない
    Serial.begin(9600);                              //通信速度は9600bps
}

void loop(){
    ps2x.read_gamepad(false, vibrate);               //コントローラーに聞いてみる。何が押されたかな？

    if(ps2x.Button(PSB_PAD_UP))                      //コントローラー十字上がおされたら
        Serial.println("PAD_UP");

    if(ps2x.Button(PSB_PAD_RIGHT))                   //コントローラー十字右がおされたら
        Serial.println("PAD_RIGHT");

    if(ps2x.Button(PSB_PAD_DOWN))                    //コントローラー十字下がおされたら
        Serial.println("PAD_DOWN");

    if(ps2x.Button(PSB_PAD_LEFT))                    //コントローラー十字左がおされたら
        Serial.println("PAD_LEFT");

    if(ps2x.Button(PSB_GREEN))                       //コントローラー緑ボタンがおされたら
        Serial.println("BUTTON_GREEN");

    if(ps2x.Button(PSB_RED))                         //コントローラー赤ボタンがおされたら
        Serial.println("BUTTON_RED");

    if(ps2x.Button(PSB_BLUE))                        //コントローラー青ボタンがおされたら
        Serial.println("BUTTON_BLUE");

    if(ps2x.Button(PSB_PINK))                        //コントローラーピンクボタンがおされたら
        Serial.println("BUTTON_PINK");

    if(ps2x.Button(PSB_L1))                          //コントローラーL１ボタンがおされたら
        Serial.println("BUTTON_L1");

    if(ps2x.Button(PSB_L2))                          //コントローラーL２ボタンがおされたら
        Serial.println("BUTTON_L2");

//  if(ps2x.Button(PSB_R1))//コントローラーR１ボタンがおされたら
//   Serial.println("BUTTON_R1");

    if(ps2x.Button(PSB_R2))                          //コントローラーR２ボタンがおされたら
        Serial.println("BUTTON_R2");

    if(ps2x.Button(PSB_R3))                          //コントローラーR３ボタンがおされたら（探せるかな?）
        Serial.println("BUTTON_R3");

    if(ps2x.Button(PSB_START))                       //コントローラースタートボタンがおされたら
        Serial.println("BUTTON_START");

    if(ps2x.Button(PSB_SELECT))                      //コントローラーセレクトボタンがおされたら
        Serial.println("BUTTON_SELECT");

    if(ps2x.Button(PSB_L3))                          //コントローラーL３ボタンがおされたら（探せるかな？）
        Serial.println("BUTTON_L3");

//コントローラーR１ボタンがおされたら
    if( ps2x.Button(PSB_R1)){
        Serial.println("BUTTON_R1");
        Serial.print("Stick Values:");
        Serial.print(ps2x.Analog(PSS_LY), DEC);      //アナログスティックの値は-128から128
        Serial.print(",");
        Serial.print(ps2x.Analog(PSS_LX), DEC);
        Serial.print(",");
        Serial.print(ps2x.Analog(PSS_RY), DEC);
        Serial.print(",");
        Serial.println(ps2x.Analog(PSS_RX), DEC);
    }

    delay(100);
}
