//-----------------------------------------------------------------------
// センサーを二つ接続してロボットを動かす
// D0: スイッチ
// D1: スイッチ
// D1スイッチを側面にD1スイッチを正面に付けると壁沿いロボットになるよ！
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <RPomniDirect.h>
#include <RPlib.h>

RPomniDirect omniBot(1.0f, 1.0f, 1.0f, 50.0f);

int touchSensor(uint8_t ch){
    return digitalRead(ch);
}

void setup(){
    pinMode(D0, INPUT_PULLUP);    //D0を入力にする
    pinMode(D1, INPUT_PULLUP);    //D1を入力にする
}

void loop(){
    if(touchSensor(D0) == ON){    //もし前方タッチセンサーD0がONだったら
        omniBot.move(0, 0, 20);   //時計回りに回る
        delay(1000);              //1秒間休憩
    }

    if(touchSensor(D1) == ON){    //もし左側タッチセンサーD1がONだったら
        omniBot.move(0, 10, 20);  //右へ旋回する
        delay(10);                //0.01秒間休憩
    }
    else{                         //そうでなかった（左側タッチセンサーD1がOFFだった）ら
        omniBot.move(0, 20, -10); //左へ旋回する
        delay(10);                //0.01秒間休憩
    }
}
