//-----------------------------------------------------------------------
// センサーを一つ接続してロボットを動かす
// D0:スイッチ
// センサーに反応があったら時計回りに回る
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <RPomniDirect.h>
#include <RPlib.h>

RPomniDirect omniBot(1.0f, 1.0f, 1.0f, 50.0f);

int touchSensor(uint8_t ch){
    return digitalRead(ch);
}

void setup(){
    pinMode(D0, INPUT_PULLUP);  //D0を入力にする
}

void loop(){
    if(touchSensor(D0) == ON){  //もし前方タッチセンサーD0がONだったら
        omniBot.move(0, 0, 20); //時計回りに回る
        delay(1000);            //1秒間休憩
    }
    else{                       //そうでなかった（前方タッチセンサーD0がOFFだった）ら
        omniBot.move(0, 20, 0); //前進する
        delay(10);              //0.01秒間休憩
    }
}
