//-----------------------------------------------------------------------
// オムニホイールロボットをコントローラーで操縦する
// 旋回有ギアチェンジバージョン
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <RPomniDirect.h>
#include <RPlib.h>
#include <PS2X_lib.h>

//おまじない
RPomniDirect omniBot(1.0f, 1.0f, 1.0f, 50.0f);           //オムニホイール調整用パラメータ
PS2X ps2x;

float xx, yy, ww;                                        //移動速度変数

void setup(){
    ps2x.config_gamepad(13, 11, 10, 12, true, true);     //おまじない（ピン設定）
}

void loop(){
    ps2x.read_gamepad();                                 //コントローラーから値を読み込む

    xx = ps2x.Analog(PSS_LX);                            //アナログスティック（左）左右
    yy = ps2x.Analog(PSS_LY);                            //アナログスティック（左）上下
    ww = ps2x.Analog(PSS_RX);                            //アナログスティック（右）左右

    if(ps2x.Button(PSB_L1) || ps2x.Button(PSB_R1)){      //L1/R1ボタンをおすと高速モード （数字を変更するともっと速度が上がるよ！）
        omniBot.move(xx / 2, yy / 2, ww / 2);
    }
    else if(ps2x.Button(PSB_L2) || ps2x.Button(PSB_R2)){ //L2/R2ボタンをおすとゆっくりモード
        omniBot.move(xx / 5, yy / 5, ww / 5);
    }
    else{                                                //普通モード
        omniBot.move(xx / 3, yy / 3, ww / 3);
    }
    delay(10);
}
