//-----------------------------------------------------------------------
// ブルドーザーのように操縦するプログラム
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <RPlib.h>
#include <PS2X_lib.h>

//おまじない(ピン接続設定)
RPmotor mc1(MC1);
RPmotor mc2(MC2);
PS2X ps2x;

int rx, lx;

void setup(){
    ps2x.config_gamepad(13, 11, 10, 12, true, true); //おまじない（ピン設定）
}

void loop(){
    ps2x.read_gamepad();                             //コントローラーから値を読み込む

    rx = ps2x.Analog(PSS_RY);                        //アナログスティック（右）上下
    lx = ps2x.Analog(PSS_LY);                        //アナログスティック（左）上下

    mc1.rotate(-rx);                                 //右オムニホイールモーターを回す
    mc2.rotate(lx);                                  //左オムニホイールモーターを回す

    delay(10);
}
