//-----------------------------------------------------------------------
// オムニホイールロボットをコントローラーで操縦する
// 左のアナログスティックだけで操縦するプログラム
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <RPomniDirect.h>
#include <RPlib.h>
#include <PS2X_lib.h>

//おまじない
RPomniDirect omniBot(1.0f, 1.0f, 1.0f, 20.0f);       //オムニホイール調整用パラメータ
PS2X ps2x;

float xx, yy;                                        //移動速度変数

void setup(){
    ps2x.config_gamepad(13, 11, 10, 12, true, true); //おまじない（ピン設定）
}

void loop(){
    ps2x.read_gamepad();                             //コントローラーから値を読み込む

    xx = ps2x.Analog(PSS_LX);                        //アナログスティック（左）左右
    yy = ps2x.Analog(PSS_LY);                        //アナログスティック（左）上下

    omniBot.move(xx / 3, yy / 3, 0);

    delay(10);
}
