//-----------------------------------------------------------------------
// 超音波距離センサーをテストする2 センサーの動作距離を測る
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

//ライブラリを取り込む
#include <Sprite.h>
#include <Matrix.h>
#include <RPlib.h>
Matrix myMatrix = Matrix(11, 13, 1);  //マトリクスLEDを使うときのオマジナイ

void setup(){
    myMatrix.setBrightness(3);        //マトリクスLEDの明るさを設定(0−8)
    myMatrix.clear();
}

void loop(){
    static int DIV = 10;              // 一けたに収まりそうな数にする分母
    int dist1;                        //変数intをdist1という名前で使う
    int dist2;                        //変数intをdist2という名前で使う
    int dispNum;                      //変数intをdispNumという名前で使う
    myMatrix.clear();
    dist1 = ussRead(US1);             //US1の距離データを変数dist1に入れる
    dist2 = ussRead(US2);             //US2の距離データを変数dist2に入れる

    if(dist1 > 99) dist1 = 99;
    if(dist2 > 99) dist2 = 99;

    dist1 /= DIV;
    dist2 /= DIV;

    // ちょっと工夫(10のけたにdist1, 1のけたにdist2が表示されるようにする)
    dispNum = dist1 * 10 + dist2;

    // 以下、表示用の処理
    myMatrix.putd2(0, 0, dispNum);    //マトリクスLEDに2けたの数字を表示

    delay(100);
}
