//-----------------------------------------------------------------------
// ライントレーサー
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

#include <ColorSensor.h>
#include "pitches.h"
#include <RPlib.h>

//おまじない(ピン接続設定)
RPmotor mc1(MC1);                                      //MC1につながっているモーターを指定する
RPmotor mc2(MC2);                                      //MC2につながっているモーターを指定する

byte Led     = 13;
byte Speaker = 2;

void setup(){
    ColorSensor.begin(24, 3);                          // カラーセンサーの積分時間を指定 x10[ms]　 値が大きいほどセンサー値の精度が良くなるが、そのぶん時間がかかる　100で10[ms] 最大 6144
    ColorSensor.led(3);
}

void loop(){
    if (ColorSensor.colorRead()){
        word clear   = ColorSensor.colorClear();
        bool isBlack = ColorSensor.colorIsBlack(1000); //1000の値を小さくしていくとセンサーと黒い色見本が1cmのところで白黒判定できる値が見つかります。
        if(isBlack){
            digitalWrite(Led, HIGH);
            tone(Speaker, NOTE_F2, 50);
            mc1.rotate(-50);                           //50の速度で負方向に回す！(最大255)
            mc2.rotate(0);
        }
        else {
            digitalWrite(Led, LOW);
            mc1.rotate(0);
            mc2.rotate(50);                            //50の速度で正方向に回す！(最大255)
        }
        delay(50);
    }
}
