//-----------------------------------------------------------------------
// カラートレーサー
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

#include <ColorSensor.h>
#include <RPlib.h>

//おまじない(ピン接続設定)
RPmotor mc1(MC1);               //MC1につながっているモーターを指定する
RPmotor mc2(MC2);               //MC2につながっているモーターを指定する

void setup(){
    ColorSensor.begin(1000, 0); // カラーセンサーの積分時間を指定 x10[ms]　 値が大きいほどセンサー値の精度が良くなるが、そのぶん時間がかかる　6000で600[ms] 最大 6144
    ColorSensor.led(3);
}

void loop(){
    if (ColorSensor.colorRead()){
        word clear = ColorSensor.colorClear();

        word red   = ColorSensor.colorRed();
        word green = ColorSensor.colorGreen();
        word blue  = ColorSensor.colorBlue();

        ColorSensor.convertHSV(red, green, blue);
        word h = ColorSensor.convertH();
        word s = ColorSensor.convertS();
        word v = ColorSensor.convertV();

        if(h > 180 && h < 270){        //カラーセンサーに反応したら前進して近づく
            mc1.rotate(-50);
            mc2.rotate(50);
        }
        else{                          //カラーセンサーに反応しなかったら何もしない
            mc1.rotate(0);
            mc2.rotate(0);
        }
    }
    delay(10);
}
