/*!
 * @file ColorLED3.ino
 * @brief コントローラーの右アナログスティックをぐるりと回転させるとその色相角度に応じて色相が変化することで色相環を体験してみる
 * LRボタンをおしてRGB各色の明度を同じように変化させた場合に、色味(色相)はどのようにみえるか
 * ３原色の各色の明るさが１００付近になると音を出す
 *
 * Copyright (c) 2014 Future Robotics Technology Center (fuRo), Masaharu Shimizu All rights reserved.<BR>
 *
 * @date Created on: 2014/07/15
 * @author Masaharu Shimizu@@fuRo
 */

#include <ColorSensor.h>
#include <PS2X_lib.h>
#include "pitches.h"

PS2X ps2x;
int Speaker = 2;
byte red(0), green(0), blue(0);
byte bri(1);

void setup(){
    ps2x.config_gamepad(13,11,10,12, true, true); //コントローラーを使うときのオマジナイ
    ColorSensor.begin(100);                       //カラーセンサーの積分時間を指定 x10[ms]　 値が大きいほどセンサー値の精度が良くなるが、そのぶん時間がかかる　100で10[ms] 最大 6144
    Serial.begin(9600);
}

void loop(){
    ps2x.read_gamepad();

    float hue(0.0);

    float rx = (float)ps2x.Analog(PSS_RX);
    float ry = (float)ps2x.Analog(PSS_RY);

    if(-2 <= rx && rx <= 2){
        rx = 0;
    }
    if(-2 <= ry && ry <= 2){
        ry = 0;
    }

    hue = 180.0 * atan2(ry, rx) / 3.14;

    if(hue < 0){
        hue = 360 + hue;
    }

    ColorSensor.convertRGB((word)hue);
    red = ColorSensor.convertRed();
    green = ColorSensor.convertGreen();
    blue = ColorSensor.convertBlue();

    if(rx == 0 && ry == 0){
        red = 0;
        green = 0;
        blue = 0;
    }

    if(97 < red && red <= 100){
        tone(Speaker, NOTE_A3, 30);
    }
    if(97 < green && green <= 100){
        tone(Speaker, NOTE_B3, 30);
    }
    if(97 < blue && blue <= 100){
        tone(Speaker, NOTE_C3, 30);
    }

    if(ps2x.ButtonPressed(PSB_R1)){
        bri = bri - 1;
    }
    if(ps2x.ButtonPressed(PSB_L1)){
        bri = bri + 1;
    }
    bri = constrain(bri, 1, 10);

    ColorSensor.ledRGB(red / bri, green / bri, blue / bri);

    Serial.print("HUE:");
    Serial.print(hue);

    Serial.print(" BRI:");
    Serial.print(bri);

    Serial.print(" RED:");
    Serial.print(red);

    Serial.print(" GREEN:");
    Serial.print(green);

    Serial.print(" BLUE:");
    Serial.println(blue);

    delay(30);
}
