//-----------------------------------------------------------------------
// 　超音波距離センサーをテストする
// 不思議楽器テルミン3
// US1/2で演奏する
// US1　音階操作
// US2　ビート操作
// US1/2同時　特殊音
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

//ライブラリを取り込む
#include <Sprite.h>
#include <Matrix.h>
#include <Tone.h>
#include <RPlib.h>

Matrix myMatrix = Matrix(11, 13, 1); //マトリクスLEDを使うときのオマジナイ
Tone tone1;                          //スピーカーを使うときのオマジナイ

void setup(){
    myMatrix.setBrightness(8);       //マトリクスLEDの明るさを設定(0−8)
    tone1.begin(D3);                 //D3にスピーカーを接続
}

void loop(){
    int dist1,dist2;
    myMatrix.clear();
    dist1 = ussRead(US1);               //US1から距離情報を取得
    dist2 = ussRead(US2);               //US2から距離情報を取得
    myMatrix.putd2(0, 0, dist1);        //マトリクスLEDに2けたの数字を表示

    if(dist1 < 3 && dist2 < 3){         //両方とも３センチより近い距離の反応
        tone1.play(NOTE_B6, 50);        //B6(ラの音)を50ミリ秒出す
        delay(50);
        tone1.play(NOTE_E7, 50);        //E7(ミの音)を50ミリ秒出す
        delay(50);
    }

    if(dist1 > 50){                     //US1が５０センチよりも反応がなければ音は出さない
        tone1.stop();
    }
    else{
        tone1.play(dist1 * 20, 100);    //dist*20Hzの音を出す
    }
    delay(dist2 * 4);
}
