//-----------------------------------------------------------------------
// 　超音波センサーをテストする 音もだす
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

//ライブラリを取り込む
#include <Sprite.h>
#include <Matrix.h>
#include <Tone.h>
#include <RPlib.h>

Matrix myMatrix = Matrix(11, 13, 1); //マトリクスLEDを使うときのオマジナイ
Tone tone1;                          //スピーカーを使うおまじない

void setup(){
    myMatrix.setBrightness(8);       //マトリクスLEDの明るさを8にする(０−８)
    tone1.begin(D3);                 //D3にスピーカーを接続
}

void loop(){
    int dist;
    myMatrix.clear();
    dist = ussRead(US1);
    myMatrix.putd2(0, 0, dist);        //マトリクスLEDに2けたの数字を表示
    tone1.play(dist * 20, 100);        //dist*20Hzの音を出す
    delay(100);
}
