//-----------------------------------------------------------------------
// 　泥棒アラーム
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

//ライブラリを取り込む
#include <Sprite.h>
#include <Matrix.h>
#include <Tone.h>
#include <RPlib.h>

Matrix myMatrix = Matrix(11, 13, 1); //マトリクスLEDを使うときのオマジナイ
Tone tone1;                          //スピーカーを使うときのオマジナイ

void setup(){
    myMatrix.setBrightness(8);       //マトリクスLEDの明るさを設定(0−8)
    tone1.begin(D3);                 //D3にスピーカーを接続
}

void loop(){
    int dist1;                   //変数dist1を使うよ
    int dist2;                   //変数dist2を使うよ
    myMatrix.clear();
    dist1 = ussRead(US1);        //US1の距離データを変数dist1に入れる
    dist2 = ussRead(US2);        //US2の距離データを変数dist2に入れる
    if(dist1 <= 50){             //US1に接続されたセンサーの50センチ以内に近づいたら
        myMatrix.putch(0,0,'1'); //'1'をマトリクスLEDに表示する
        tone1.play(NOTE_C7,100); //C7(ドの音)を100ミリ秒出す
        delay(50);
    }
    else
    if(dist2 <= 50)              //US2に接続されたセンサーの50センチ以内に近づいたら
    {
        myMatrix.putch(0,0,'2'); //'2'をマトリクスLEDに表示する
        tone1.play(NOTE_G6,100); //G6(ソの音)を100ミリ秒出す
        delay(50);
    }
    else{
        myMatrix.putch(0,0,'0'); //'0'をマトリクスLEDに表示する
    }
    delay(100);
}
