//-----------------------------------------------------------------------
// ジュークボックス④(モーターを回す機能を追加)
//-----------------------------------------------------------------------
// You can get more RTTTL (RingTone Text Transfer Language) songs from
// http://code.google.com/p/rogue-code/wiki/ToneLibraryDocumentation
// http://arcadetones.emuunlim.com/index.htm

//ライブラリを取り込む
#include <Sprite.h>
#include <Matrix.h>
#include <Button.h>
#include <RPlib.h>
#include <Tone.h>

Matrix myMatrix = Matrix(11, 13, 1); //マトリクスLEDを使うときのオマジナイ
Button SW1      = Button(D0, LOW);   //D0に接続されたスイッチをSW1と名づける
Button SW2      = Button(D1, LOW);   //D1に接続されたスイッチをSW2と名づける
Tone tone1;                          //スピーカーを使うときのオマジナイ
RPmotor mc1(MC1);                    //MC1につながっているモーターを指定
RPmotor mc2(MC2);                    //MC2につながっているモーターを指定

//曲データ
char *song0 = "M5A:d=4,o=6,b=164:16c,16a5,16b5,16e,16d,16a5,16b5,16e,16c,16a5,16b5,16e,16d,16a5,16b5,16e,16f,16a5,16c,16f,16e,16a5,16b5,16e,16f,16a5,16c,16f,16e,16c,16a5,16c,16g,16b5,16d,16g,16f,16b5,16d,16f,16g,16b5,16d,16g,16f,16d,16f,16g,16a,";
char *song1 = "M6A:d=4,o=6,b=173:8c,16c,16g5,8d,16d,16g5,8e,16e,16g5,8f,8d,8g,16g,16e,16f,16e,8d,8g,16g,16e,16f,16e,8d,8c,16c,16g5,8d,16d,16g5,8e,16e,16g5,8e,8f,8g,16g,16e,16f,16e,8d,8g,16g,16e,16f,16e,8d,4c,8c5,";
char *song2 = "M7A:d=4,o=5,b=173:4g,4a,16b,16b,8b,16c6,16p,16c6,16p,8d#6,16c6,16p,16g,16g,8c6,8d#6,16c6,16p,16g,16g,8c6,16b,16p,16a,16p,16g,16p,16f,16p,8g,16c,16c,16f,16p,16e,16p,8d#6,16c6,16p,16g,16g,8c6,8d#6,16c6,16p,16g,16g,8c6,16b,16a,8g,16f,16e,8f,8g,16c,16c,16f,16p,16e,16p,8d,16b4,16p,16g4,16g4,8b4,8g,16d,16p,16b4,16b4,8d,16g,8p,16p,8g";
char *song3 = "Beethoven:d=4,o=6,b=100:16g5,16g5,16g5,d#5,16f5,16f5,16f5,d5,16g5,16g5,16g5,16d#5,16g#5,16g#5,16g#5,16g5,16d#,16d#,16d#,c,16g5,16g5,16g5,16d5,16g#5,16g#5,16g#5,16g5,16f,16f,16f,d";
char *song4 = "TurkishMa:d=4,o=6,b=160:16b5,16a5,16g#5,16a5,8c,8p,16d,16c,16b5,16c,8e,8p,16f,16e,16d#,16e,16b,16a,16a#,16a,16b,16a,16a#,16a,8c7,8p,8a,8c7,8b,8a,8g,8a,8b,8a,8g,8a,8b,8a,8g,8f#,e";

int n;                                         //曲数を入れる変数

void setup(void){
    tone1.begin(D2);                           //D2にスピーカーを接続
    myMatrix.setBrightness(3);
    myMatrix.putd2(0, 0, 0);                   //マトリクスLEDに00を表示
}

void loop(void){
    SW1.listen();                              //SW1の状態をマイコンに聞く
    SW2.listen();                              //SW2の状態をマイコンに聞く

    if (SW1.onPress()){                        //もしSW1がおされたら
        n++;                                   //変数nの値に1を足す
        n = n % 4;                             //0から3までの数字になるように計算(剰余演算)
        myMatrix.putd2(0, 0, n);               //マトリクスLEDに2けたの数字を表示
    }

    if (SW2.onPress()){                        //もしSW2がおされたら
        switch (n){
        case 0:                                //0の場合
            mc1.rotate(70);                    //70の速度で正方向(プラス)に回す(範囲は-255～255)
            mc2.rotate(70);                    //70の速度で正方向(プラス)に回す(範囲は-255～255)
            myMatrix.scrollText("song0", 100); //テキストをスクロール
            tone1.play_rtttl(song0);           //song0という変数に入った曲を流す
            mc1.rotate(0);                     //0の速度で正方向(プラス)に回す(範囲は-255～255)
            mc2.rotate(0);                     //0の速度で正方向(プラス)に回す(範囲は-255～255)
            break;

        case 1:                                //1の場合
            myMatrix.scrollText("song1", 100); //テキストをスクロール
            tone1.play_rtttl(song1);           //song1という変数に入った曲を流す
            break;

        case 2:                                //2の場合
            myMatrix.scrollText("song2", 100); //テキストをスクロール
            tone1.play_rtttl(song2);           //song2という変数に入った曲を流す
            break;

        case 3:                                //3の場合
            myMatrix.scrollText("song3", 100); //テキストをスクロール
            tone1.play_rtttl(song3);           //song3という変数に入った曲を流す
            break;
        }
        n = 0;                                 //0に戻す
        myMatrix.putd2(0, 0, n);               //マトリクスLEDに2けたの数字を表示
    }
}
