//-----------------------------------------------------------------------
// ラインの回転
// プロペラ
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

//ライブラリを取り込む
#include <Sprite.h>
#include <Matrix.h>

Matrix myMatrix = Matrix(11, 13, 1); //マトリクスLEDを使うときのオマジナイ

void setup(){
    myMatrix.clear();                //マトリクスLEDの表示を消す
}

int x1,x2,y1,y2;                     //始点と終点に使うx・y座標を用意

void loop(){
    //y軸に沿ってラインが動く
    x1 = 0;
    x2 = 7;
    for(int y = 0; y <= 7; y++){
        y1 = y;
        y2 = 7 - y;
        myMatrix.line(x1,y1,x2,y2); //座標(x1,y1)から座標(x2,y2)へ線を引く
        delay(100);
        myMatrix.clear();           //マトリクスLEDの表示を消す
    }

    //x軸に沿ってラインが動く
    y1 = 7;
    y2 = 0;

    for(int x = 1; x <= 6; x++){
        x1 = x;
        x2 = 7 - x;
        myMatrix.line(x1,y1,x2,y2); //座標(x1,y1)から座標(x2,y2)へ線を引く
        delay(100);
        myMatrix.clear();           //マトリクスLEDの表示を消す
    }
}
