//-----------------------------------------------------------------------
// 周波数の代わりにコード番号を使う
// スイッチを使う
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
//ライブラリを読み込む
#include <Sprite.h>
#include <Matrix.h>
#include <Tone.h>
#include <RPlib.h>
#include <Button.h>


Matrix myMatrix = Matrix(11, 13, 1); //マトリクスLEDを使うときのオマジナイ
Tone tone1;                          //スピーカーを使うときのオマジナイ
Button SW1 = Button(D0, HIGH);       //D0に接続されたスイッチをSW1と名づける
Button SW2 = Button(D1, HIGH);       //D1に接続されたスイッチをSW2と名づける
void setup(){
    tone1.begin(D2);                 //D2にスピーカーを接続
}

void loop(){
    SW1.listen();                 //SW1の状態をマイコンに聞く
    SW2.listen();                 //SW2の状態をマイコンに聞く

    if (SW1.isPressed()){         //もしSW1が押されたら
        tone1.play(NOTE_C4, 100); //C4(ドの音)を100ミリ秒出す
        delay(100);
    }
    if (SW2.isPressed()){         //もしSW2が押されたら
        tone1.play(NOTE_D4, 100); //D4(レの音)を100ミリ秒出す
        delay(100);
    }
}
