//-----------------------------------------------------------------------
// マトリクスLEDを使ったコントローラーの動作確認②
// バイブレーション機能を使う
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
//ライブラリを取り込む
#include <Sprite.h>
#include <Matrix.h>
#include <RPlib.h>
#include <PS2X_lib.h>

PS2X ps2x;                                        //コントローラーに名前をつける
Matrix myMatrix = Matrix(11, 13, 1);              //マトリクスLEDを使うときのオマジナイ

int vibrate = 0;                                  //変数intをvibrateという名前で使う(はじめは0)

void setup(){
    myMatrix.setBrightness(3);                    //マトリクスLEDの明るさを設定(0−8)
    myMatrix.putd2(0, 0, 0);                      //マトリクスLEDに2けたの数字を表示
    ps2x.config_gamepad(13,11,10,12, true, true); //コントローラーを使うときのオマジナイ
}

void loop(){
    ps2x.read_gamepad(false,vibrate);     //コントローラーから値を読み取る

    vibrate = ps2x.Analog(PSS_RY);        //アナログ右スティックY方向
    vibrate = constrain(vibrate,0,99);    //0-99に制限(実際の数字は0-128)
    myMatrix.putd2(0, 0, vibrate);        //マトリクスLEDに2けたの数字を表示

    delay(50);
}
