//-----------------------------------------------------------------------
// コントローラーでLEDを操作①
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

//ライブラリを読み込む
#include <PS2X_lib.h>
#include <Sprite.h>
#include <Matrix.h>
#include <RPlib.h>
#include <Tone.h>

PS2X ps2x;                                           //コントローラーに名前をつける
Matrix myMatrix = Matrix(11, 13, 1);                 //マトリクスLEDを使うときのオマジナイ
Tone tone1;                                          //スピーカーを使うときのオマジナイ

int x = 0, y = 0;                                    //変数intをxとyという名前で使う(はじめは0)

void setup(){
    ps2x.config_gamepad(13, 11, 10, 12, true, true); //コントローラーを使うときのオマジナイ
    tone1.begin(D2);                                 //D2にスピーカーを接続
}

void loop(){

    myMatrix.write(x, y, HIGH);      //LEDを点灯
    delay(50);
    myMatrix.write(x, y, LOW);       //LEDを消灯

    ps2x.read_gamepad();             //コントローラーから値を読み取る

    if (ps2x.Button(PSB_PAD_UP)){    //もし十字ボタンの上が押されたら
        y--;
    }
    if (ps2x.Button(PSB_PAD_RIGHT)){ //もし十字ボタンの右が押されたら
        x++;
    }
    if (ps2x.Button(PSB_PAD_LEFT)){  //もし十字ボタンの左が押されたら
        x--;
    }
    if (ps2x.Button(PSB_PAD_DOWN)){  //もし十字ボタンの下が押されたら
        y++;
    }

    //xとyが画面からはみ出ないように制限する(constrain)
    x = constrain(x, 0, 7);          //xの値を0から7の数字におさめる
    y = constrain(y, 0, 7);          //yの値を0から7の数字におさめる
}
