//-----------------------------------------------------------------------
// マトリクスLEDに変数iの値を表示④
// 10回押すと音が出る
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

//ライブラリを取り込む
#include <Sprite.h>
#include <Matrix.h>
#include <Button.h>
#include <RPlib.h>
#include <Tone.h>

Matrix myMatrix = Matrix(11, 13, 1); //マトリクスLEDを使うときのオマジナイ
Button SW1 = Button(D0, LOW);        //D0に接続されたスイッチをSW1と名づける
Button SW2 = Button(D1, LOW);        //D1に接続されたスイッチをSW2と名づける
Tone tone1;

//SE1
char *sound1 = "M1A:d=4,o=5,b=120:16g,16c6,16g5,16c6,16g5,16c6";                                                //se_getpoint
char *sound2 = "M2A:d=4,o=6,b=180:16g,16c7,16f7,16p,16c7,16d7,16g7,16p,16g,16c7,16d7,16f7,16g7,16d7,16c7,16d7"; //se_twincle

//SE2
//char *sound1 = "one:d=4,o=4,b=200:16f8,16f7";//count1
//char *sound2 = "ten:d=4,o=4,b=200:16b7,16g7,16b7,16g7,16b7,16g7,16a7,16b7";//count10

int i = 0;                     //変数intをiという名前で使う(はじめは0)

void setup(){
    myMatrix.setBrightness(3); //マトリクスLEDの明るさを設定(0−8)
    myMatrix.putd2(0, 0, i);   //マトリクスLEDに2けたの数字を表示
    tone1.begin(D2);
}

void loop(){

    SW1.listen();                     //SW1の状態をマイコンに聞く
    SW2.listen();                     //SW2の状態をマイコンに聞く

    if (SW1.onPress()){               //もしSW1が押されたら
        i++;                          //変数iの値に1を足す
        myMatrix.putd2(0, 0, i);      //マトリクスLEDに2けたの数字を表示
        tone1.play_rtttl(sound1);     //sound1の曲を流す
        if (i == 10){
            tone1.play_rtttl(sound2); //sound2の曲を流す
        }
    }
    if (SW2.onPress()){               //もしSW2が押されたら
        i--;                          //変数iの値から1を引く
        myMatrix.putd2(0, 0, i);      //マトリクスLEDに2けたの数字を表示
    }
}
