//-----------------------------------------------------------------------
// マトリクスLEDに変数iの値を表示①
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

//ライブラリを取り込む
#include <Sprite.h>
#include <Matrix.h>
#include <Button.h>
#include <RPlib.h>

Matrix myMatrix = Matrix(11, 13, 1); //マトリクスLEDを使うときのオマジナイ
Button SW1 = Button(D0, HIGH);       //D0に接続されたスイッチをSW1と名づける

int i = 0;                           //変数intをiという名前で使う(はじめは0)

void setup(){
    myMatrix.setBrightness(3);       //マトリクスLEDの明るさを設定(0−8)
    myMatrix.putd2(0, 0, i);         //マトリクスLEDに2けたの数字を表示
}

void loop(){

    SW1.listen();                //SW1の状態をマイコンに聞く
    if(SW1.onPress()){           //もしSW1が押されたら
        i++;                     //変数iの値に1を足す
        myMatrix.putd2(0, 0, i); //マトリクスLEDに2けたの数字を表示
    }
}
