//-----------------------------------------------------------------------
// マトリクスLEDの点がグルグル回るように動く
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

#include <Sprite.h>     // Sprite before Matrix
#include <Matrix.h>

const int dtime = 50;   //LEDが移動する待ち時間
//                   DIN, CLK, LOAD, #chips
Matrix myMatrix = Matrix(11, 13, 1);

void setup(){
    myMatrix.clear();   //マトリクスLEDの表示を消す
}

char x = 0, y = 0;      //変数charをxとyという名前で使う(はじめは0)

void loop(){
    y = 0;
    for (x = 0; x < 8; x++){
        myMatrix.write(x, y, HIGH);   //LEDを点灯させる
        delay(dtime);
        myMatrix.write(x, y, LOW);    //LEDを消灯させる
    }
    x = 7;
    for (y = 1; y < 8; y++){
        myMatrix.write(x, y, HIGH);   //LEDを点灯させる
        delay(dtime);
        myMatrix.write(x, y, LOW);    //LEDを消灯させる
    }
    y = 7;
    for (x = 6; x > 0; x--){
        myMatrix.write(x, y, HIGH);   //LEDを点灯させる
        delay(dtime);
        myMatrix.write(x, y, LOW);    //LEDを消灯させる
    }
    x = 0;
    for (y = 7; y > 0; y--){
        myMatrix.write(x, y, HIGH);   //LEDを点灯させる
        delay(dtime);
        myMatrix.write(x, y, LOW);    //LEDを消灯させる
    }
}
