//-----------------------------------------------------------------------
// sound.h
// サウンド関係
// ROBOPRO RobotBattler
//  written by kodachi kodachi@furo  2014/6/16
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#ifndef _SOUND_H_
#define _SOUND_H_

class SoundManager
{
public:
    SoundManager(){
        m_timeStop = 0;
        m_step     = MAIN_STEP_INIT;
        m_stepSub  = SUB_STEP_INIT;
        m_timeSub  = 0;
    }

    void setup();

private:
    typedef enum _main
    {
        MAIN_STEP_INIT,
        MAIN_STEP_MOVE,
        MAIN_STEP_DEATH,
        MAIN_STEP_WIN,
        MAIN_STEP_3,
    }MAIN_STEP;
    typedef enum _sub
    {
        SUB_STEP_INIT,
        SUB_STEP_2,
        SUB_STEP_3
    }SUB_STEP;

    int m_timeStop;
    MAIN_STEP m_step;
    SUB_STEP m_stepSub;

    int m_timeSub;        // 汎用

public:
    void setStep(MAIN_STEP step){
        m_step    = step;
        m_stepSub = SUB_STEP_INIT;
    }

    void setStep(MAIN_STEP step, SUB_STEP stepSub){
        m_step    = step;
        m_stepSub = stepSub;
    }

    void setStepSub(SUB_STEP stepSub){
        m_stepSub = stepSub;
    }

    MAIN_STEP getStep(){return m_step;}

    SUB_STEP getStepSub(){return m_stepSub;}

public:
    virtual void init();

    virtual void exec();

    virtual void update();

    virtual void checkCommand(int cmd);

    void move();

    void death();

    void win();

    void playData(int pData[][2], int size);
};

#define KYUUFU 0
#define HACHIBU 4        // 8分音符ぐらいのつもり

#endif
