//-----------------------------------------------------------------------
// input.h
// 入力関係　ヘッダー
// ROBOPRO RobotBattler
//  written by kodachi kodachi@furo  2014/6/16
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#ifndef _INPUT_H_
#define _INPUT_H_
#include <PS2X_lib.h> //for v1.6
class PS2X;

#define RENSHA_TIME 10
class InputManager
{
public:
    void setup();

    PS2X ps2x;        // create PS2 Controller Class
public:
    virtual void init();

    virtual void exec(){;}

    virtual void update();

    void checkCommand(int8_t cmd);

private:
    byte m_vibrate;
    int m_vibrateTime;
    // 連射
    // 連射タイマーがあるうちにボタンを押すと、連射値が加算される
    // 連射タイマーが0になると、連射値も0になる
    uint8_t m_renshaTimer;        // RENSHA_TIMEがセットされる
    uint32_t m_renshaValue;
    uint16_t m_renshaButton;

public:
    void setRenshaTimer(uint16_t b){
        m_renshaButton = b;
        m_renshaTimer  = RENSHA_TIME;
    }

    uint8_t getRenshaTimer(){return m_renshaTimer;}

    bool decRenshaTimer(){
        bool ret = false;
        if(m_renshaTimer > 0){
            m_renshaTimer--;
            if(m_renshaTimer == 0)
                return true;
        }
        return ret;
    }

    void setVibrate(int time = 5);

    uint32_t getRenshaValue(){return m_renshaValue;}

    void addRenshaValue(uint16_t b){
        if(b == m_renshaButton)
            m_renshaValue++;
        else
            m_renshaValue = 0;
    }

    void clearRenshaValue(){m_renshaValue = 0;}

    // 連射判定
    // button: ボタン指定　num: 連射回数でtrueを返し連射数リセット
    bool isRensha(unsigned int button, int num);
};

#endif
