//-----------------------------------------------------------------------
// リンクロボットをコントローラーで動かすプログラム
// 左右のアナログスティックが左右の脚の動きに対応
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <RPlib.h>
#include <PS2X_lib.h>

//おまじない
RPmotor mcl(MC2);    //MC2に繋がっているモータを指定する(左脚)
RPmotor mcr(MC1);    //MC1に繋がっているモータを指定する(右脚)
PS2X ps2x;

float ll, rr;        //移動速度変数

void setup(){
    ps2x.config_gamepad(13, 11, 10, 12, true, true); //コントローラーを使うときのオマジナイ
}

void loop(){
    ps2x.read_gamepad();           //コントローラーから値を読み取る

    ll = ps2x.Analog(PSS_LY);      //アナログ左スティック上下
    rr = ps2x.Analog(PSS_RY);      //アナログ右スティック上下

    ll = constrain(ll, -127, 127); // llの値が-127から127の間におさまるようにする
    rr = constrain(rr, -127, 127); // rrの値が-127から127の間におさまるようにする

    mcl.rotate(-2 * ll);           //左のモーターを回転(-255～255の範囲で指定)
    mcr.rotate(2 * rr);            //右のモーターを回転(-255～255の範囲で指定)

    delay(10);                     //10ミリ秒待つ
}
